unit about;
{
    About.pas, part of the winMClient
    Copyright (C) 1999 Peter Millard

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

interface

uses
    ShellAPI, 
    Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
    StdCtrls, ExtCtrls;

type
  TfrmAbout = class(TForm)
    GroupBox1: TGroupBox;
    lblTitle: TLabel;
    lblVersion: TLabel;
    lblCopyright: TLabel;
    Image1: TImage;
    lblXtra: TLabel;
    lblMode: TLabel;
    Button1: TButton;
    lblWeb: TLabel;
    btnWeb: TButton;
    btnMail: TButton;
    lblMail: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure btnWebClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmAbout: TfrmAbout;

implementation

{$R *.DFM}

procedure TfrmAbout.FormCreate(Sender: TObject);
begin
    Self.Caption := 'About ' + Application.Title;
    lblTitle.Caption := Application.Title;
    Image1.Picture.Assign(Application.Icon);

    lblTitle.Caption := '';
    lblVersion.Caption := '';
    lblMode.Caption := '';
    lblCopyright.Caption := '';
    lblXtra.Caption := '';

end;

procedure TfrmAbout.btnWebClick(Sender: TObject);
begin
    if (Sender = btnWeb) or (Sender = lblWeb) then
        ShellExecute(0, 'open', PChar(lblWeb.Caption), nil, nil, SW_NORMAL)
    else
        ShellExecute(0, 'open', PChar(lblMail.Caption), nil, nil, SW_NORMAL);
end;

end.
