unit Dialer1;
{
    Dialer1.pas, part of the winMClient
    Copyright (C) 1999 Peter Millard

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

    ======================================
    Main unit for the winMClient winsock
    application. This is the main form
    and handles all of the winsock
    communication, sequence logic,
    and logging.


---------------------------------------
}
interface

uses
    iniFiles,
    ClipBrd,
    FMemo,
    Common,
    Registry,
    ShellAPI,
    WinSock, 
    Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
    ScktComp, StdCtrls, ComCtrls, Buttons, ImgList, ExtCtrls, Menus,
    TrayIcon, LimitMe, Spin;

type
  TfrmMain = class(TForm)
    PageControl1: TPageControl;
    shtMain: TTabSheet;
    shtRaw: TTabSheet;
    Memo1: TMemo;
    Edit1: TEdit;
    btnSend: TButton;
    btnOpen: TButton;
    btnClose: TButton;
    Label3: TLabel;
    cboList: TComboBox;
    btnDial: TSpeedButton;
    btnConnect: TSpeedButton;
    Label4: TLabel;
    pnlStat: TPanel;
    GroupBox1: TGroupBox;
    Label5: TLabel;
    pnlConnect: TPanel;
    pnlTime: TPanel;
    Label6: TLabel;
    pnlSpeed: TPanel;
    Label7: TLabel;
    Timer1: TTimer;
    MainMenu1: TMainMenu;
    View1: TMenuItem;
    Normal1: TMenuItem;
    Debug1: TMenuItem;
    Control1: TMenuItem;
    Connect1: TMenuItem;
    DisConnect1: TMenuItem;
    N1: TMenuItem;
    Dial1: TMenuItem;
    HangupKill1: TMenuItem;
    N2: TMenuItem;
    ShowVersionInfo1: TMenuItem;
    ShowHistoryInfo1: TMenuItem;
    N3: TMenuItem;
    Exit1: TMenuItem;
    ShowLicense1: TMenuItem;
    ConnInfo1: TMenuItem;
    N4: TMenuItem;
    CurrentClients1: TMenuItem;
    PopupMenu1: TPopupMenu;
    Restore1: TMenuItem;
    N5: TMenuItem;
    Dial2: TMenuItem;
    HangupKill2: TMenuItem;
    N6: TMenuItem;
    Exit2: TMenuItem;
    Tray1: TTrayIcon;
    Image1: TImage;
    shtConfig: TTabSheet;
    Configure1: TMenuItem;
    chkAutoConnect: TCheckBox;
    chkAutoDial: TCheckBox;
    chkAuth: TCheckBox;
    grpAuth: TGroupBox;
    Label8: TLabel;
    txtUser: TEdit;
    txtPasswd: TEdit;
    Label9: TLabel;
    btnSave: TButton;
    chkMin: TCheckBox;
    Label10: TLabel;
    spnRedial: TSpinEdit;
    N7: TMenuItem;
    AboutwMasqDialer1: TMenuItem;
    btnLockDial: TSpeedButton;
    CurrentLogFile1: TMenuItem;
    chkSavePass: TCheckBox;
    Connect2: TMenuItem;
    Disconnect2: TMenuItem;
    chkDisKills: TCheckBox;
    chkRestore: TCheckBox;
    Socket1: TClientSocket;
    Label1: TLabel;
    txtServer: TEdit;
    txtPort: TEdit;
    Label2: TLabel;
    btnKill: TSpeedButton;
    btnLockKill: TSpeedButton;
    btnRefresh: TSpeedButton;
    Bevel1: TBevel;
    Label11: TLabel;
    lblServer: TLabel;
    procedure btnOpenClick(Sender: TObject);
    procedure Socket1Connect(Sender: TObject; Socket: TCustomWinSocket);
    procedure Socket1Read(Sender: TObject; Socket: TCustomWinSocket);
    procedure btnSendClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Socket1Disconnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure btnSaveClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnDialClick(Sender: TObject);
    procedure btnKillClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure Normal1Click(Sender: TObject);
    procedure Debug1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure ShowVersionInfo1Click(Sender: TObject);
    procedure ShowLicense1Click(Sender: TObject);
    procedure ShowHistoryInfo1Click(Sender: TObject);
    procedure ConnInfo1Click(Sender: TObject);
    procedure CurrentClients1Click(Sender: TObject);
    procedure Tray1DblClick(Sender: TObject);
    procedure chkAuthClick(Sender: TObject);
    procedure Configure1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Restore1Click(Sender: TObject);
    procedure Exit2Click(Sender: TObject);
    procedure AboutwMasqDialer1Click(Sender: TObject);
    procedure ContactDownload1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Tray1Restore(Sender: TObject);
    procedure btnRefreshClick(Sender: TObject);
    procedure Socket1Error(Sender: TObject; Socket: TCustomWinSocket;
      ErrorEvent: TErrorEvent; var ErrorCode: Integer);
    procedure btnLockKillClick(Sender: TObject);
    procedure btnLockDialClick(Sender: TObject);
    procedure CurrentLogFile1Click(Sender: TObject);
    procedure chkSavePassClick(Sender: TObject);
    procedure txtPasswdChange(Sender: TObject);
    procedure cboListChange(Sender: TObject);
    procedure Connect1Click(Sender: TObject);
  private
    { Private declarations }
    rtxt: TStringList;              // string list for the "entire" response
    ttxt: TStringList;              // string list for the last receive block
    cmdq: TStringList;              // command queue to be sent out
    curcmd: string;                 // current command sent
    connect: boolean;               // connection global flag
    startup: boolean;               // are we in the startup sequence?
    starttime: longint;             // start time for this connection in seconds
    curtime: longint;               // current time in seconds
    Version: string;                // Version info for this client
    oldstat: string;                // value of the last STAT command
    CurDial: integer;               // Current dial attempt number
    Log: TextFile;                  // Log file pointer
    passwd: string;                 // current un-encrypted password
    confile: string;                // Configuration filename
    LogOpen: boolean;               // Is the Log file open?
    DoDial: boolean;                // Internal flag, are we dialing?
    DoClose: boolean;               // Internal flag, are we trying to close?
    NoLog: boolean;                 // Is the NoLog flag active?
    DfltConn: integer;              // Default connection idx
    fserv: string;
    fport: string;

    procedure ParseResults;
    procedure ShowBlock;
    procedure Menus(en: boolean);
    procedure WriteLog(tmps: string);
    procedure OpenLog;

    procedure SaveFileSettings(fn: string);
    procedure LoadFileSettings(fn: string);

    procedure SaveRegSettings;
    procedure LoadRegSettings;
  public
    { Public declarations }
    procedure Init;
    procedure ConnectToServer;
    procedure SendCmd(cmd: string);
  end;

var
  frmMain: TfrmMain;

{---------------------------------------}
{---------------------------------------}
{---------------------------------------}
implementation
uses About, passwd;

{$R *.DFM}
{$R  icons.RES}

{---------------------------------------}
procedure TfrmMain.btnOpenClick(Sender: TObject);
begin
    ConnectToServer;
end;

{---------------------------------------}
procedure TfrmMain.ConnectToServer;
var
    HstPtr: PHostEnt;
    cnme, tmps: string;
begin
    // Fire up the socket connection
    // and establish the connection

    with Socket1 do begin
        // 7/28/99 - move this code around..
        try
            Port := StrToInt(txtPort.Text);
        except
            MessageDlg('Invalid Port! Please enter a port NUMBER.', mtError, [mbOK], 0);
            exit;
        end;

        // 7/29/99 - new code to handle IP #'s and Names..
        cnme := txtServer.Text;
        // 9/30/99 - use new IsValidIP function instead of this..
        // this call was apparently the cause of lookups on machines
        // that didn't already have ready access to some DNS server.
        {
        HstPtr := GetHostByName(PChar(cnme));
        if HstPtr = nil then
            Address := cnme
        else
            Host := cnme;
        }
        if IsValidIP(cnme) then
            Address := cnme
        else
            Host := cnme;

        tmps := 'Trying to connect to: ' + host + ' on port ' + txtPort.Text;
        WriteLog(tmps);
        StartUp := true;
        pnlStat.Caption := 'Connecting to ' + Host;
        CurCmd := 'CONNECT';
        oldstat := '';
        Open;
        end;
end;

{---------------------------------------}
procedure TfrmMain.Socket1Connect(Sender: TObject; Socket: TCustomWinSocket);
begin
    // we are connected... log the event
    // the server automatically sends us are first text..
    // handle all incoming text from the server in the Socket's READ event
    with Memo1.Lines do begin
        Clear;
        WriteLog('Socket connected to server.');
        Add('Socket Connected to server..');
        btnConnect.Down := true;
        Menus(false);
        Connect1.Enabled := false;
        DisConnect1.Enabled := true;
        end;
    lblServer.Caption := txtServer.Text + ':' + txtPort.Text;
end;

{---------------------------------------}
procedure TfrmMain.Socket1Read(Sender: TObject; Socket: TCustomWinSocket);
var
    i: integer;
    tmps: string;
begin
    // read in text from the server..
    // parse it into the ttxt string list,
    // then call the Parse Results function..

    tmps := Trim(Socket.ReceiveText);
    pparse(Chr(10), tmps, ttxt);

    // log the event if it's not a cyclic cmd
    if (CurCmd <> 'CTIME') AND (CurCmd <> 'STAT') then begin
        for i := 0 to ttxt.count - 1 do begin
            Memo1.Lines.Add(ttxt[i]);
            WriteLog('READ: ' + ttxt[i]);
            end;
        // show status..
        pnlStat.Caption := ttxt[ttxt.Count-1];
        Tray1.Hint := 'winMClient: ' + pnlStat.Caption;
        end;

    // actually process the results
    ParseResults;
end;

{---------------------------------------}
procedure TfrmMain.SendCmd(cmd: string);
var
    cc, tmps: string;
begin
    {
    This routine handles the command queue...
    we are using a FIFO type of thing here so we don't
    overload the events with multiple commands before the
    current command finishes.

    To fire off the next command in the queue, we send a blank
    string into this function, otherwise, the command is just
    added to the stack.
    }

    // add the cmd to the stack if it's not blank
    if cmd <> '' then
        cmdq.Add(cmd);

    if (cmdq.Count = 1) or (cmd = '') then begin
        // only send the new cmd when it's the only 1 left
        // OR when we receive the blank string
        CurCmd := cmdq[0];
        CurCmd := Trim(curcmd);
        if (CurCmd <> 'STAT') and (CurCmd <> 'CTIME') then begin
            // pgm 10/13/99 - don't show the password in the debug..
            if Copy(CurCmd, 1, 4) = 'PASS' then begin
                Memo1.Lines.Add('SENDING PASSWORD...');
                tmps := 'PASSWORD (not logged)'
                end
            else begin
                Memo1.Lines.Add('SENDING COMMAND: ' + CurCmd);
                tmps := CurCmd;
                end;
            WriteLog('CMD: ' + tmps);
            end;
        rtxt.Clear;

        // actually send the text to the socket
        cc := CurCmd + Chr(13) + Chr(10);
        Socket1.Socket.SendText(cc);
        end;
end;

{---------------------------------------}
procedure TfrmMain.Menus(en: boolean);
begin
    {
    Handle the enabling and disabling of all the
    proper btns and menu items for different
    states of the client.

    en = true for server connected...
    en = false for server not connected...
    }

    Connect1.Enabled := not en;
    DisConnect1.Enabled := en;
    Dial1.Enabled := en;
    HangupKill1.Enabled := en;
    ShowVersionInfo1.Enabled := en;
    ShowLicense1.Enabled := en;
    ShowHistoryInfo1.Enabled := en;
    CurrentClients1.Enabled := en;

    // enable or disable dial/hangup stuff..
    if not en then begin
        Dial1.Enabled := en;
        HangupKill1.Enabled := en;
        ConnInfo1.Enabled := en;
        end
    else begin
        if cboList.Items.Count > 0 then
            ConnInfo1.Enabled := true;

        if oldstat = 'UP' then begin
            Dial1.Enabled := false;
            HangupKill1.Enabled := true;
            end
        else begin
            Dial1.Enabled := ConnInfo1.Enabled;
            HangupKill1.Enabled := false;
            end;
        end;


    // handle locked stuff..
    if btnLockDial.Down then
        Dial1.Enabled := false;
    if btnLockKill.Down then
        HangupKill1.Enabled := false;

    // set btns
    btnDial.Enabled := Dial1.Enabled;
    Dial2.Enabled := Dial1.Enabled;
    btnKill.Enabled := HangupKill1.Enabled;
    HangupKill2.Enabled := HangupKill1.Enabled;
    Connect2.Enabled := Connect1.Enabled;
    Disconnect2.Enabled := Disconnect1.Enabled;

end;

{---------------------------------------}
procedure TfrmMain.ParseResults;
var
    i: integer;
    Prefix, tmps: string;
    timedelta: longint;
    trs: TResourceStream;
    redial: boolean;
    dt: TDateTime;
begin
    // do stuff depending on the results and the command
    // grab the first 4 chars to check for certian cmds..
    Prefix := Copy(CurCmd, 1, 4);

    {
    Some notes about ttxt and rtxt :)

    ttxt = a stringlist which holds all of the output
            from the current read. The may or may not
            be all of the text that we are expecting from
            the server

    rtxt = complete received text from (possibly) multiple
            read events.

    }

    // add the ttxt stringlist to our rtxt stringlist.
    for i := 0 to ttxt.count - 1 do
        rtxt.Add(ttxt[i]);

    // Only process events when we get the final "READY" string..
    // exit otherwise
    if rtxt[rtxt.count-1] <> 'READY' then exit;

    if curcmd = 'CONNECT' then begin
        if Startup then begin
            // send auth info.. OR get the connection list
            if chkAuth.Checked then
                SendCmd('USER:' + txtUser.Text)
            else
                SendCmd('LIST');
            end;
        end

    else if Prefix = 'USER' then begin
        if not chkSavePass.checked then with frmPasswd do begin
            // prompt for the password since it's not being saved
            Password.Text := '';
            if ShowModal = mrCancel then begin
                SendCmd('AUTH');
                exit;
                end;
            Passwd := Password.Text;
            end;
        // send the password
        SendCmd('PASS:' + Passwd);
        end

    else if Prefix = 'PASS' then
        // get the authentication status
        SendCmd('AUTH')

    else if CurCmd = 'AUTH' then begin
        // get authentication info...
        if rtxt[0] = 'NOT AUTHORIZED' then
            MessageDlg('Problem Authenticating your username/passwd!',
                mtError, [mbOK], 0);
        SendCmd('LIST');
        Startup := true;
        end

    else if CurCmd = 'LIST' then begin
        // get the list of connections.
        // add the items to the combo box..
        for i := 1 to rtxt.count - 3 do
            cboList.Items.Add(rtxt[i]);

        // pgm 7/28/99 - handle deafult connection index
        if DfltConn > 0 then
            cboList.ItemIndex := DfltConn
        else
            cboList.ItemIndex := 0;

        Menus(true);
        // if we are in "startup" mode, then get the lock status
        if Startup then SendCmd('LINFO');
        end

    else if curcmd = 'STAT' then begin
        // Get the Status INFO
        tmps := rtxt[0];
        pparse(':', tmps, rtxt);
        if rtxt[0] = 'UP' then begin
            // connection is up...
            tmps := 'UP';
            pnlConnect.Caption := 'CONNECTED via ' + rtxt[1];
            for i := 0 to cboList.Items.Count - 1 do begin
                if rtxt[1] = cboList.Items[i] then cboList.ItemIndex := i;
                end;
            pnlSpeed.Caption := rtxt[2];

            // if the last status was not UP, get the connection TIME
            // otherwise, get the current time from the server..
            if oldstat <> 'UP' then
                SendCmd('TIME')
            else
                SendCmd('CTIME');
            end
        else begin
            // connection is down...
            tmps := 'DOWN';
            pnlConnect.Caption := 'NOT CONNECTED!';
            pnlTime.Caption := '';
            pnlSpeed.Caption := '';
            CurCmd := '';
            {
            enabled the timer...this will allow ALL
            clients to catch an UP status when someone
            else fires up the connection
            }
            if not Timer1.Enabled then
                Timer1.Enabled := true;

            // if we are auto-dialing, flip the dial flag
            if Startup and chkAutoDial.Checked then
                DoDial := true;

            if DoDial then begin
                CurDial := 1;
                SendCmd('DIAL:' + cboList.Items[cboList.ItemIndex]);
                // show the window when starting a dial operation
                if chkRestore.Checked then
                    Tray1.Restore;
                end;

            if DoClose then begin
                // we are closing the socket connection...
                // so kill the timer.
                Timer1.Enabled := false;
                Socket1.Close;
                tmps := '';
                end;
            end;

        {
        If we've changed status, then set the proper
        tray icon.. pulls the icons from a Resource Stream
        }
        if tmps = '' then begin
            // set the icon to the app's icon
            Image1.Picture.Icon.Assign(Self.Icon);
            Tray1.Icon := Image1.Picture.Icon;
            end
        else if (tmps <> oldstat) then begin
            // change the tray icon to up or down..
            oldstat := tmps;
            tmps := tmps + 'ICON';
            trs := TResourceStream.Create(HInstance, PChar(tmps), 'PMICON');
            Image1.Picture.Icon.LoadFromStream(trs);
            Tray1.Icon := Image1.Picture.Icon;
            trs.Free;
            end;
        Menus(true);
        end

    else if Prefix = 'DIAL' then begin
        // check for some error cases in the redial...
        redial := true;
        for i := 0 to rtxt.count - 1 do begin
            if pos('connected to', lowercase(rtxt[i])) > 0 then
                redial := false;
            if pos('ERROR', rtxt[i]) > 0 then
                MessageDlg(rtxt[i], mtError, [mbOK], 0);
            end;

        if redial then begin
            inc(CurDial);
            if CurDial <= spnRedial.Value then
                // send another dial command
                SendCmd('DIAL:' + cboList.Items[cboList.ItemIndex]);
            end
        else begin
            // get the status
            SendCmd('STAT');
            end;
        end

    else if CurCmd = 'KILL' then begin
        // get the output of the KILL command..
        if pos('ERROR', rtxt[0]) > 0 then
            MessageDlg(rtxt[0], mtError, [mbOK], 0);
        if chkDisKills.Checked then DoClose := true;
        SendCmd('STAT')
        end

    else if Prefix = 'LOCK' then begin
        // Lock the connection
        if pos('ERROR', rtxt[0]) > 0 then
            MessageDlg(rtxt[0], mtError, [mbOK], 0);
        SendCmd('LINFO')
        end

    else if Prefix = 'UNLO' then begin
        // unlock the connection
        if pos('ERROR', rtxt[0]) > 0 then
            MessageDlg(rtxt[0], mtError, [mbOK], 0);
        SendCmd('LINFO')
        end

    else if CurCmd = 'LINFO' then begin
        // get the lock info, and setup btns and stuff.
        tmps := rtxt[0];
        pparse(':', tmps, rtxt);
        if rtxt.count >= 2 then begin
            if SToInt(rtxt[1]) > 0 then btnLockKill.Down := true;
            if SToInt(rtxt[0]) > 0 then btnLockDial.Down := true;
            if btnLockDial.Down then btnDial.Enabled := false;
            if btnLockKill.Down then btnKill.Enabled := false;
            end;
        SendCmd('STAT');
        end

    else if CurCmd = 'TIME' then begin
        // now that we have the start time, get the current time
        StartTime := SToInt(rtxt[0]);
        SendCmd('CTIME');
        end

    else if CurCmd = 'VERSION' then begin
        // display version info...
        tmps := 'wMasqDialer ' + Version + ' (Peter Millard)' + Chr(13);
        tmps := tmps + 'C-MServer ' + rtxt[0];
        MessageDlg(tmps, mtInformation, [mbOK], 0);
        end

    else if CurCmd = 'WHO' then begin
        // show who else has clients open
        tmps := rtxt[0];
        pparse(':', tmps, rtxt);
        tmps := 'CURRENT CLIENTS' + chr(13);
        for i := 0 to rtxt.count - 1 do
            tmps := tmps + rtxt[i] + chr(13);
        MessageDlg(tmps, mtInformation, [mbOK], 0);
        end

    else if (CurCmd = 'HISTORY') or (CurCmd = 'LICENSE') then begin
        // show History info or the License
        ShowBlock;
        end

    else if Prefix = 'CINF' then begin
        // show connection details
        ShowBlock;
        end

    else if CurCmd = 'CTIME' then begin
        // got the current server time..
        // calculate the connection duration
        curtime := SToInt(rtxt[0]);
        timedelta := curtime - starttime;
        dt := UnixTimeToDT(timedelta);
        if dt > 0.0 then
            pnlTime.Caption := FormatDateTime('hh:nn:ss', dt)
        else
            pnlTime.Caption := '';

        // make sure the timer is enabled
        if not Timer1.Enabled then
            Timer1.Enabled := true;
        end;

    // remove the top command from the commmand queue..
    if cmdq.Count > 0 then
        cmdq.Delete(0);

    // if we have more commands in the queue,
    // then execute the next one in the stack.
    if cmdq.Count > 0 then SendCmd('');

end;

{---------------------------------------}
procedure TfrmMain.ShowBlock;
var
    ef: boolean;
    i: integer;
begin
    // show everything between BEGIN and END in the memo box form..
    with frmMemo.Memo1 do begin
        frmMemo.Caption := CurCmd + ' Output';
        Lines.Clear;
        for i := 1 to rtxt.count - 1 do begin
            if rtxt[i] = 'END' then
                break
            else
                Lines.Add(rtxt[i]);
            end;
        end;
    frmMemo.Button1.Caption := 'Close';
    frmMemo.Show;
end;

{---------------------------------------}
procedure TfrmMain.btnSendClick(Sender: TObject);
begin
    // send command entered in the debug tab
    SendCmd(Edit1.Text);
end;

{---------------------------------------}
procedure TfrmMain.btnCloseClick(Sender: TObject);
begin
    // close the connection from the debug tab
    Socket1.Close;
end;

{---------------------------------------}
procedure TfrmMain.FormCreate(Sender: TObject);
var
    keys, vals: TStringList;
    i: integer;
    srv, prt, cprm: string;
    resave: boolean;
begin
    // init our vars..
    rtxt := TStringList.Create;
    ttxt := TStringList.Create;
    cmdq := TStringList.Create;
    curcmd := '';
    srv := '';
    prt := '';
    NoLog := false;
    shtRaw.TabVisible := false;
    Debug1.Visible := false;

    confile := '-USEREG';

    // Get Command line args...
    // ------------------------------
    for i := 1 to ParamCount do begin
        cprm := lowercase(trim(ParamStr(i)));
        if cprm = '/debug' then begin
            shtRaw.TabVisible := true;
            Debug1.Visible := true;
            end;

        if (cprm = '/f') or (cprm = '/file') then begin
            if ParamCount >= i + 1 then
                confile := ParamStr(i+1);
            end;

        if (cprm = '/server') or (cprm = '/s') then begin
            if ParamCount >= i+1 then
                srv := ParamStr(i+1);
            end;

        if (cprm = '/port') or (cprm = '/p') then begin
            if ParamCount >= i+1 then
                prt := ParamStr(i+1);
            end;

        if (cprm = '/nolog') then
            NoLog := true;

        end;

    // do stuff for debug..
    if shtRaw.TabVisible then
        Debug1Click(Self)
    else
        Normal1Click(Self);

    // get our settings...
    if confile = '-USEREG' then
        LoadRegSettings
    else
        LoadFileSettings(confile);

    // do stuff from cmd line args..
    fserv := '';
    fport := '';
    if srv <> '' then begin
        fserv := txtServer.Text;
        txtServer.Text := srv;
        end;
    if prt <> '' then begin
        fport := txtPort.Text;
        txtPort.Text := prt;
        end;
    Menus(false);

    // get the version info..
    Keys := TStringList.Create;
    Vals := TStringList.Create;
    Version := 'Version: ' + GetVersionInfo(keys, vals);
    keys.Free;
    vals.Free;

    // do log stuff..
    OpenLog;
    Writelog('--------------------------');
    Writelog('winMClient Started');

    // setup flags
    DoDial := false;
    DoClose := false;
end;

{---------------------------------------}
procedure TfrmMain.LoadRegSettings;
var
    reg: TRegistry;
    tmps: string;
    resave: boolean;
begin
    {load settings from the registry.}

    reg := TRegistry.Create;
    with reg do begin
        RootKey := HKEY_LOCAL_MACHINE;
        connect := KeyExists('SOFTWARE\Vantek\wMasqDialer');
        OpenKey('SOFTWARE\Vantek\wMasqDialer', true);
        txtServer.Text := ReadString('Server');
        try
            txtPort.Text := IntToStr(ReadInteger('Port'));
        except
            // pgm 10/13/99 - change dflt port to 224
            txtPort.text := '224';
        end;

        resave := true;

        // this is necessary, as some early client versions
        // stored all the info the HKEY_LOCAL_MACHINE section
        // of the registry
        if not KeyExists('Username') then begin
            // load user spec settings from the user section of the registry
            CloseKey;
            RootKey := HKEY_CURRENT_USER;
            OpenKey('SOFTWARE\Vantek\wMasqDialer', true);
            resave := false;
            end;

        try
            chkAutoDial.Checked := ReadBool('AutoDial');
            chkAutoConnect.Checked := ReadBool('AutoConnect');
            chkAuth.Checked := ReadBool('UseAuth');
            chkMin.Checked := ReadBool('StartMinimized');
            chkDisKills.Checked := ReadBool('DisconnectKills');
            chkSavePass.Checked := ReadBool('SavePass');
            spnRedial.Value := ReadInteger('Redial');
        except
        end;

        // pgm 7/28/99 - new option..
        try
            chkRestore.Checked := ReadBool('RestoreWin');
        except
            chkRestore.Checked := true;
        end;

        try
            DfltConn := ReadInteger('DefaultConn');
        except
            DfltConn := -1;
        end;

        txtUser.Text := ReadString('Username');

        if chkSavePass.Checked then begin
            tmps := ReadString('Passwd');
            CryptStr(tmps);
            txtPasswd.Text := tmps;
            Passwd := tmps;
            end;

        txtPasswd.Enabled := chkSavePass.Checked;
        grpAuth.Enabled := chkAuth.Checked;

        if connect then begin
            try
                Self.Left := ReadInteger('POS-Left');
                Self.Top := ReadInteger('POS-Top');
                Self.Width := ReadInteger('POS-Width');
                Self.Height := ReadInteger('POS-Height');
            except
            end;

            end;
        CloseKey;
        end;
    reg.Free;

    // handle clients that have all reg info the LOCAL_MACHINE key
    if resave then
        btnSaveClick(Self);
end;

{---------------------------------------}
procedure TfrmMain.SaveRegSettings;
var
    reg: TRegistry;
    tmps: string;
begin
    // Save the settings to the registry
    reg := TRegistry.Create;
    with reg do begin
        RootKey := HKEY_LOCAL_MACHINE;
        OpenKey('SOFTWARE\Vantek\wMasqDialer', true);
        WriteString('Server', txtServer.Text);
        WriteInteger('Port', SToInt(txtPort.Text));

        if KeyExists('Username') then begin
            DeleteKey('AutoDial');
            DeleteKey('AutoConnect');
            DeleteKey('POS-Left');
            DeleteKey('POS-Top');
            DeleteKey('POS-Height');
            DeleteKey('POS-Width');
            DeleteKey('UseAuth');
            DeleteKey('Username');
            DeleteKey('Passwd');
            DeleteKey('StartMinimized');
            DeleteKey('Redial');
            end;
        CloseKey;

        RootKey := HKEY_CURRENT_USER;
        OpenKey('SOFTWARE\Vantek\wMasqDialer', true);
        WriteBool('AutoDial', chkAutoDial.Checked);
        WriteBool('AutoConnect', chkAutoConnect.Checked);
        WriteBool('DisconnectKills', chkDisKills.Checked);
        WriteBool('SavePass', chkSavePass.Checked);
        WriteInteger('POS-Left', Self.Left);
        WriteInteger('POS-Top', Self.Top);
        WriteInteger('POS-Height', Self.Height);
        WriteInteger('POS-Width', Self.Width);

        WriteBool('UseAuth', chkAuth.Checked);
        WriteString('Username', txtUser.Text);
        tmps := txtPasswd.Text;
        CryptStr(tmps);
        WriteString('Passwd', tmps);
        WriteBool('StartMinimized', chkMin.Checked);

        // 7/28/99 - new options
        WriteBool('RestoreWin', chkRestore.Checked);
        WriteInteger('DefaultConn', DfltConn);

        WriteInteger('Redial', spnRedial.Value);
        CloseKey;
        end;
    reg.Free;
end;

{---------------------------------------}
procedure TfrmMain.LoadFileSettings(fn: string);
var
    tmps: string;
    f: TiniFile;
begin
    {load settings from an INI file..}
    f := TiniFile.Create(fn);
    with f do begin
        txtServer.Text := ReadString('MAIN', 'Server', '');

        // pgm 10/13/99 - change dflt port to 224
        txtPort.Text := IntToStr(ReadInteger('MAIN', 'Port', 224));

        chkAutoDial.Checked := ReadBool('USER', 'AutoDial', false);
        chkAutoConnect.Checked := ReadBool('USER', 'AutoConnect', true);
        chkAuth.Checked := ReadBool('USER', 'UseAuth', false);
        chkMin.Checked := ReadBool('USER', 'StartMinimized', false);
        chkDisKills.Checked := ReadBool('USER', 'DisconnectKills', false);
        chkSavePass.Checked := ReadBool('USER', 'SavePass', false);

        // 7/28/99 - new options
        chkRestore.Checked := ReadBool('USER', 'RestoreWin', true);
        DfltConn := ReadInteger('USER', 'DefaultConn', -1);

        txtUser.Text := ReadString('USER', 'Username', '');
        spnRedial.Value := ReadInteger('USER', 'Redial', 3);

        if chkSavePass.Checked then begin
            tmps := ReadString('USER', 'Passwd', '');
            CryptStr(tmps);
            txtPasswd.Text := tmps;
            Passwd := tmps;
            end;

        txtPasswd.Enabled := chkSavePass.Checked;
        grpAuth.Enabled := chkAuth.Checked;

        connect := txtServer.Text <> '';
        if connect then begin
            Self.Left := ReadInteger('USER', 'POS-Left', 100);
            Self.Top := ReadInteger('USER', 'POS-Top', 100);
            Self.Width := ReadInteger('USER', 'POS-Width', Self.Width);
            Self.Height := ReadInteger('USER', 'POS-Height', Self.Height);
            end;
        end;
    f.Free;

end;

{---------------------------------------}
procedure TfrmMain.SaveFileSettings(fn: string);
var
    f: TiniFile;
    tmps: string;
begin
    {save settings to an INI file..}
    f := TiniFile.Create(fn);
    with f do begin
        WriteString('MAIN', 'Server', txtServer.Text);
        WriteInteger('MAIN', 'Port', SToInt(txtPort.Text));

        WriteBool('USER', 'AutoDial', chkAutoDial.Checked);
        WriteBool('USER', 'AutoConnect', chkAutoConnect.Checked);
        WriteBool('USER', 'DisconnectKills', chkDisKills.Checked);
        WriteBool('USER', 'SavePass', chkSavePass.Checked);
        WriteInteger('USER', 'POS-Left', Self.Left);
        WriteInteger('USER', 'POS-Top', Self.Top);
        WriteInteger('USER', 'POS-Height', Self.Height);
        WriteInteger('USER', 'POS-Width', Self.Width);

        WriteBool('USER', 'UseAuth', chkAuth.Checked);
        WriteString('USER', 'Username', txtUser.Text);
        tmps := txtPasswd.Text;
        CryptStr(tmps);
        WriteString('USER', 'Passwd', tmps);
        WriteBool('USER', 'StartMinimized', chkMin.Checked);

        // 7/28/99 - new options
        WriteBool('USER', 'RestoreWin', chkRestore.Checked);
        WriteInteger('USER', 'DefaultConn', DfltConn);

        WriteInteger('USER', 'Redial', spnRedial.Value);
        end;
    f.Free;

end;

{---------------------------------------}
procedure TfrmMain.OpenLog;
var
    sizelimit: integer;
    i, cs: longint;
    tmps, fn, fn2: string;
    OldLog: TextFile;
begin
    {
    Check to make sure we are supposed to log,
    then open the log file. This routine also
    checks the size of the logfile, and trims
    the file if it exceeds a specific size.

    Note that the FileSize function returns
    the number of 128 byte blocks, thus:
    800 * 128 = 102,400 bytes = 100 Kb.
    }
    if NoLog then begin
        LogOpen := false;
        exit;
        end;

    fn := ExtractFilePath(Application.EXEName) + 'winmclient.log';
    AssignFile(Log, fn);

    // only keep the log file for 100 Kb
    // 100 Kb = 800 "blocks"
    sizelimit := 800;

    if not FileExists(fn) then
        ReWrite(Log)
    else begin
        Append(Log);
        if FileSize(Log) > sizelimit then begin
            { trim the first half of the log off}
            CloseFile(Log);
            fn2 := ChangeFileExt(fn, '.old');
            RenameFile(fn, fn2);
            AssignFile(OldLog, fn2);
            Reset(OldLog);

            AssignFile(Log, fn);
            ReWrite(Log);

            cs := FileSize(OldLog) div 2;

            while not eof(OldLog) do begin
                Readln(OldLog, tmps);
                if FilePos(OldLog) >= cs then
                    Writeln(Log, tmps);
                end;
            CloseFile(OldLog);
            DeleteFile(fn2);
            end;
        end;
    LogOpen := true;
end;

{---------------------------------------}
procedure TfrmMain.WriteLog(tmps: string);
begin
    // write a line to the logger.
    // make sure the log file is open.
    if NoLog then exit;
    if not LogOpen then OpenLog;

    // pgm 10/13/99 - put in some exception protection.
    try
        Writeln(Log, DateTimeToStr(Now) + ' - ' + tmps);
    except
    end;
end;


{---------------------------------------}
procedure TfrmMain.Socket1Disconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
    // we lost our connection to the mserver.
    Timer1.Enabled := false;
    lblServer.Caption := ' <DISCONNECTED> ';
    WriteLog('Socket Disconnected from Host.');
    Memo1.Lines.Add('SOCKET DISCONNECTED!');
    pnlStat.Caption := 'SOCKET DISCONNECTED';
    pnlConnect.Caption := '';
    pnlTime.Caption := '';
    pnlSpeed.Caption := '';
    cboList.Items.Clear;

    btnConnect.Down := false;
    Image1.Picture.Icon.Assign(Self.Icon);
    Tray1.Icon := Image1.Picture.Icon;

    Menus(false);

    try
        if not NoLog then
            CloseFile(Log);
    except
    end;
    LogOpen := false;

    if CurCmd = 'CLOSE' then begin
        Tray1.Free;
        Self.Close;
        end;

end;

{---------------------------------------}
procedure TfrmMain.btnSaveClick(Sender: TObject);
var
    srv, prt: string;
begin
    // Save the settings to the registry
    // if we are over-riding the normal configs..
    // switch the text boxes..

    if fserv <> '' then begin
        srv := txtServer.text;
        txtServer.Text := fserv;
        end;

    if fport <> '' then begin
        prt := txtPort.Text;
        txtPort.Text := fport;
        end;

    // save the settings to the registry or a file
    if confile = '-USEREG' then
        SaveRegSettings
    else
        SaveFileSettings(confile);

    // if we are over-riding the normal configs..
    // switch the text boxes..
    if fserv <> '' then begin
        txtServer.Text := srv;
        end;

    if fport <> '' then begin
        txtPort.Text := prt;
        end;
end;

{---------------------------------------}
procedure TfrmMain.FormShow(Sender: TObject);
begin
    {}
end;

{---------------------------------------}
procedure TfrmMain.btnDialClick(Sender: TObject);
begin
    {
    Fire up the connection...
    if the socket is not connected,
    set the DoDial flag, and connect.
    the other events will then automatically
    fire off the dial command.
    }
    if not Socket1.Active then begin
        DoDial := true;
        ConnectToServer;
        end
    else begin
        CurDial := 1;
        SendCmd('DIAL:' + cboList.Items[cboList.ItemIndex]);
        end;
end;

{---------------------------------------}
procedure TfrmMain.btnKillClick(Sender: TObject);
begin
    // kill the current ppp connection
    SendCmd('KILL');
end;

{---------------------------------------}
procedure TfrmMain.Timer1Timer(Sender: TObject);
begin
    // get the status
    Startup := false;
    if cmdq.count <= 0 then
        SendCmd('STAT');
end;

{---------------------------------------}
procedure TfrmMain.PageControl1Change(Sender: TObject);
begin
    // sync the TabPages and the menu items
end;

{---------------------------------------}
procedure TfrmMain.Normal1Click(Sender: TObject);
begin
    PageControl1.ActivePage := shtMain;
    PageControl1Change(Self);
end;

{---------------------------------------}
procedure TfrmMain.Debug1Click(Sender: TObject);
begin
    PageControl1.ActivePage := shtRaw;
    PageControl1Change(Self);
end;

{---------------------------------------}
procedure TfrmMain.Exit1Click(Sender: TObject);
begin
    // Close everything
    Self.Close;
end;

{---------------------------------------}
procedure TfrmMain.ShowVersionInfo1Click(Sender: TObject);
begin
    // get the version info from the server
    SendCmd('VERSION');
end;

{---------------------------------------}
procedure TfrmMain.ShowLicense1Click(Sender: TObject);
begin
    // get the license info from the server
    SendCmd('LICENSE');
end;

{---------------------------------------}
procedure TfrmMain.ShowHistoryInfo1Click(Sender: TObject);
begin
    // get the version history from the server
    SendCmd('HISTORY');
end;

{---------------------------------------}
procedure TfrmMain.ConnInfo1Click(Sender: TObject);
begin
    // show connection info
    SendCmd('CINFO:' + cboList.Items[cboList.ItemIndex]);
end;

{---------------------------------------}
procedure TfrmMain.CurrentClients1Click(Sender: TObject);
begin
    // who is connected to the server?
    SendCmd('WHO');
end;

{---------------------------------------}
procedure TfrmMain.Tray1DblClick(Sender: TObject);
begin
    // show the form
    Tray1.Restore;
end;

{---------------------------------------}
procedure TfrmMain.chkAuthClick(Sender: TObject);
begin
    grpAuth.Enabled := chkAuth.Checked;
end;

{---------------------------------------}
procedure TfrmMain.Configure1Click(Sender: TObject);
begin
    PageControl1.ActivePage := shtConfig;
    PageControl1Change(Self);
end;

{---------------------------------------}
procedure TfrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    // release our stringlists..
    rtxt.Free;
    ttxt.Free;
    cmdq.Free;

    // save our settings.
    btnSaveClick(Self);
end;

{---------------------------------------}
procedure TfrmMain.Restore1Click(Sender: TObject);
begin
    Tray1.Restore;
end;

{---------------------------------------}
procedure TfrmMain.Exit2Click(Sender: TObject);
begin
    Self.Close;
end;

{---------------------------------------}
procedure TfrmMain.AboutwMasqDialer1Click(Sender: TObject);
begin
    // show the About box.
    with frmAbout do begin
        lblTitle.caption := Application.Title;
        lblVersion.caption := Version;
        lblMode.caption := 'Freeware';
        lblWeb.Caption := 'http://www.buffnet.net/~millard/winmclient.html';
        lblMail.Caption := 'mailto:millard@buffnet.net';
        lblCopyright.Caption := 'Author: Peter Millard';
        lblXtra.Caption := 'June 16, 1999';
        ShowModal;
        end;
end;

{---------------------------------------}
procedure TfrmMain.ContactDownload1Click(Sender: TObject);
var
    tmps: string;
begin
    // show contact info..

    tmps := 'Contact Info:' + chr(13) + chr(10);
    tmps := tmps + 'Author: millard@buffnet.net' + chr(13) + chr(10);
    tmps := tmps + chr(13) + chr(10);
    tmps := tmps + 'winMClient Home Page:' + chr(13) + chr(10);
    tmps := tmps + 'http://www.buffnet.net/~millard/winmclient.html' + chr(13) + chr(10);
    tmps := tmps + chr(13) + chr(10);
    tmps := tmps + 'Info copied to clipboard.';

    Clipboard.SetTextBuf(PChar(tmps));

    MessageDlg(tmps, mtInformation, [mbOK], 0);

end;

{---------------------------------------}
procedure TfrmMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
    {
    Before the form closes, make sure
    that the socket connection is closed!
    }
    if Socket1.Active then begin
        CurCmd := 'CLOSE';
        CanClose := false;
        Socket1.Close;
        end;
end;

{---------------------------------------}
procedure TfrmMain.Tray1Restore(Sender: TObject);
begin
    frmMain.Show;
    SetForegroundWindow(Self.Handle);
end;

{---------------------------------------}
procedure TfrmMain.Init;
begin
    if (connect) AND (chkAutoConnect.Checked) then begin
        startup := true;
        ConnectToServer;
        end;
end;

{---------------------------------------}
procedure TfrmMain.btnRefreshClick(Sender: TObject);
begin
    SendCmd('STAT');
end;

{---------------------------------------}
procedure TfrmMain.Socket1Error(Sender: TObject; Socket: TCustomWinSocket;
  ErrorEvent: TErrorEvent; var ErrorCode: Integer);
begin
    if ErrorCode = 10061 then begin
        // no server?
        ErrorCode := 0;
        btnConnect.Down := false;
        MessageDlg('Error Trying to Connect to Server! ' + chr(13) + 'Make sure the server is running.',
                mtError, [mbOK], 0);
        pnlStat.Caption := 'ERROR Connecting.';
        end
    else begin
        // generic handler
        MessageDlg('Winsock Error Number: ' + IntToStr(ErrorCode),
            mtError, [mbOK], 0);
        pnlStat.Caption := 'WINSOCK ERROR: ' + IntToStr(ErrorCode);
        Timer1.Enabled := false;
        cmdq.Clear;
        ErrorCode := 0;
        end;
end;

{---------------------------------------}
procedure TfrmMain.btnLockKillClick(Sender: TObject);
begin
    if not btnLockKill.Down then
        SendCmd('UNLOCK:KILL')
    else
        SendCmd('LOCK:KILL');
end;

{---------------------------------------}
procedure TfrmMain.btnLockDialClick(Sender: TObject);
begin
    if not btnLockDial.Down then
        SendCmd('UNLOCK:DIAL')
    else
        SendCmd('LOCK:DIAL');
end;

{---------------------------------------}
procedure TfrmMain.CurrentLogFile1Click(Sender: TObject);
var
    fn: string;
begin
    {view current log file...}
    fn := ExtractFilePath(Application.EXEName) + 'winmclient.log';
    RunCmd('notepad.exe ' + fn);
end;

{---------------------------------------}
procedure TfrmMain.chkSavePassClick(Sender: TObject);
begin
    txtPasswd.Enabled := chkSavePass.Checked;
end;

{---------------------------------------}
procedure TfrmMain.txtPasswdChange(Sender: TObject);
begin
    Passwd := txtPasswd.Text;
end;

{---------------------------------------}
procedure TfrmMain.cboListChange(Sender: TObject);
begin
    DfltConn := cboList.ItemIndex;
end;

{---------------------------------------}
procedure TfrmMain.Connect1Click(Sender: TObject);
begin
    // connect to mserver
    // try to connect or disconnect
    if Sender <> btnConnect then
        btnConnect.Down := not btnConnect.Down;

    if btnConnect.Down then
        ConnectToServer
    else
        Socket1.Close;
end;

end.
